/*********************************************************************************************
*******************************  SPACE INVADERS 2002  ****************************************
****************************   BY JESSE CORRINGTON  ****************************************           
**
**********************************************************************************************/

#include <allegro.h>
#include <fstream.h>
#include <time.h>


// constant declarations
const int scrx = 800;
const int scry = 600;
const int MAX_BULLETS = 50;
const int MAX_INVADERS  = 20;
const int MAX_STARS = 200;

//directions and bullet types
typedef enum{UP = -1, DOWN = 1, LEFT, RIGHT, INVADER = 2, PLAYER = 3};

//power up types
typedef enum{RAPID = 0, EXTRAGUY = 1, ENERGY = 2, AGILITY = 3, DOULBE = 4, SPREAD = 5, 
			 PWRUP = 6, SHRINK = 7};

int RightMostInvader;
int LeftMostInvader;

int num_player_bullets;
int num_invader_bullets;

int num_invaders = 10;
int invader_shoot_speed = 50;

int invaderDirection = RIGHT;

int level = 1;

BITMAP *buffer;
BITMAP *bmp_player_ship;
BITMAP *bmp_bullet;
BITMAP *bmp_invader;
BITMAP *bmp_invader_bullet;
BITMAP *bmp_powerup[8];
BITMAP *bmp_explosion[5];
BITMAP *bmp_little_ship;

SAMPLE *wav_shoot;
SAMPLE *wav_explosion;
SAMPLE *wav_music;

//function prototypes
void update_screen();   //draws graphics 
void game_loop();       //main game loop
int get_bulletnum();    //gets the lowest available free bullet to use for new bullet
void check_bullets();   //checks to see if bullets are off screen, and if so free's them
int BBCD();				//bounding box collision detection

/*********************************************************************************************
									Class definitoon section
*********************************************************************************************/


/*********************************************************************************************
									bounding box class
*********************************************************************************************/
class class_bounding_box
{
public:
	int top,bottom,left,right;

	void set(int t, int b, int l, int r)
	{
		top = t;
		bottom = b;
		left = l;
		right = r;
		return;
	}
	void move(int x_units, int y_units)
	{
		top += y_units;
		bottom += y_units;
		left += x_units;
		right += x_units;
	}
		
};


/*********************************************************************************************
									explosion class
*********************************************************************************************/
class class_explosion
{
public:
	int frame_num;
	int x;
	int y;
	bool active;

	void draw()
	{
		masked_blit(bmp_explosion[frame_num], buffer, 0, 0, x - bmp_explosion[frame_num]->w, y - bmp_explosion[frame_num]->h, bmp_explosion[frame_num]->w, bmp_explosion[frame_num]->h);
		frame_num++;
		return;
	}
	void check()
	{
		if (frame_num > 4) active = false;
		return;
	}
	void reset()
	{
		x = 0;
		y = 0;
		frame_num = 0;
		active = false;
		return;
	}
};


/*********************************************************************************************
									powerup class
*********************************************************************************************/
class class_powerup
{
public:
	int type;
	int x;
	int y;
	bool active;
	class_bounding_box bounding_box;

	void move()
	{
		y++;
		bounding_box.move(0, 1);
		return;
	}
	void draw()
	{
		blit(bmp_powerup[type],buffer, 0, 0, x - 15,y - 15,30,30);
		return;
	}
	void check()
	{
		if (y > scry) active = false;
		return;
	}
	void reset()
	{
		x = 0;
		y = 0;
		active = false;
		return;
	}
};


/*********************************************************************************************
									Player Class
*********************************************************************************************/
class class_player
{
public:
	int x;
	int y;
	int lives;
	int energy;
	int score;
	int speed;
	int agility;
	int gun_power;
	int rapid_time_left;


	bool rapid;
	bool pwr_agility;

	class_bounding_box bounding_box;

	//default constructer
	class_player(int c_agility = 4, int c_x = 200, int c_y = scry - 150, int c_lives = 2, 
				 int c_speed = 4, int c_energy = 8, int c_gun_pwr = 1)
	{
		x = c_x;
		y = c_y;
		lives = c_lives;
		energy = c_energy;
		speed = c_speed;
		agility = c_agility;
		gun_power = c_gun_pwr;
		return;
    }


	void move(int &X, int &Y)
	{
		if (key[KEY_UP] && Y > 0)	
		{
			Y -= agility;
			bounding_box.move(0, -agility);
		}
		if (key[KEY_DOWN] && Y < scry - 40)		
		{
			Y += agility;
			bounding_box.move(0, agility);
		}
		if (key[KEY_LEFT] && X > 40)		
		{
			X -= agility;
			bounding_box.move(-agility, 0);
		}
		if (key[KEY_RIGHT] && X < scrx - 40)	
		{
			X += agility;	
			bounding_box.move(agility, 0);
		}
		return;
	}

	void draw(int X, int Y)
	{
		masked_blit(bmp_player_ship, buffer, 0, 0 , X - (bmp_player_ship->w/2), Y - (bmp_player_ship->h/2), bmp_player_ship->w, bmp_player_ship->h);
		return;
	}

	void reset()
	{
		x = scrx/2;
		y = scry - 150;
		bounding_box.set(y - bmp_player_ship->h/2,y + bmp_player_ship->h/2,x - bmp_player_ship->w/2,x + bmp_player_ship->w/2);
		return;
	}
};


class_player player;
/*********************************************************************************************
									star class
*********************************************************************************************/
class class_star
{
public:
	int x;
	int y;
	int type;
	bool active;

	//default constructer
	class_star(int c_type = 1, bool c_active = false)
	{
		type = c_type;
		active = c_active;
		return;
    }

	void create()
	{
		x = rand() % scrx;
		y = 0;
		active = true;
		return;
	}
	void create2()
	{
		x = rand()%scrx;
		y = rand()%scry;
		active = true;
		return;
	}
	void check()
	{
		if (y > scry) active = false;
		return;
	}
	void move()
	{
		y+=player.speed;
		return;
	}
	void draw()
	{
		putpixel(buffer, x, y, makecol16(255,255,255));
		return;
	}
};


/*********************************************************************************************
									invader Class
*********************************************************************************************/
class class_invader
{
public:
	int x;
	int y;
	int type;
	int energy;
	bool alive;
	class_bounding_box bounding_box;

	void draw(int X, int Y)
	{
		blit(bmp_invader, buffer, 0, 0 , X - bmp_invader->w/2, Y - bmp_invader->h/2, bmp_invader->w, bmp_invader->h);
		return;
	}
	void reset()
	{
		x = 0;
		y = 0;
		alive = false;
		return;
	}

};


/*********************************************************************************************
									Bullet Class
*********************************************************************************************/
class class_bullet
{
public:
	int x;
	int y;
	int direction;
	int type;
	bool active;
	class_bounding_box bounding_box;
	
	//default constructer
	class_bullet(bool c_active = false, int c_x = 0, int c_y = 0)
	{
		active = c_active;
		x = c_x;
		y = c_y;
		return;
    }

	void move(int &b_y,int dir)
	{
		b_y += dir*5;
		return;
	}

	void draw(int bx, int by)
	{
		if (type == PLAYER)		blit(bmp_bullet, buffer, 0, 0 , bx- bmp_bullet->w/2, by-bmp_bullet->h/2, bmp_bullet->w, bmp_bullet->h);
		if (type == INVADER)	blit(bmp_invader_bullet, buffer, 0, 0, bx - bmp_invader_bullet->w, by - bmp_invader_bullet->h, bmp_invader_bullet->w, bmp_invader_bullet->h);
		return;
	}
	void reset()
	{
		active = false;
		if (type == PLAYER && num_player_bullets > 0)	num_player_bullets--;
		if (type == INVADER && num_invader_bullets > 0) num_invader_bullets--;
		return;
	}


};
/*********************************************************************************************
									end of class Definition section
*********************************************************************************************/


//~~~~~~~~~~~global definitions
class_invader invader[MAX_INVADERS];
class_bullet bullet[MAX_BULLETS];
class_star star[MAX_STARS];
class_powerup powerup[10];
class_explosion explosion[30];


/*********************************************************************************************
								Function Section starts here
*********************************************************************************************/



/*********************************************************************************************
								bounding box collision detection
*********************************************************************************************/
int BBCD(class_bounding_box b1, class_bounding_box b2) 
{ 
	if(b1.left > b2.right) return 0; 
	if(b1.right < b2.left) return 0; 
	if(b1.top > b2.bottom) return 0; 
	if(b1.bottom < b2.top) return 0; 
	return 1; 
}


/*********************************************************************************************
			update screen : draws all of the graphics to the buffer
*********************************************************************************************/
void update_screen()
{
	int i = 0;
	int testbullet = 0;
/*	if (num_player_bullets>0) {
		while (bullet[testbullet].type != PLAYER && bullet[testbullet].active == false) 
		{
			testbullet++;
			if (testbullet>MAX_BULLETS) break;
		}
	}*/
	//draw the stars
	for (i=0;i<MAX_STARS;i++)
	{
		if (star[i].active == true)		star[i].draw();
	}
	
	//draw the powerup
	for (i=0;i<10;i++)
	{
		if (powerup[i].active == true)		powerup[i].draw();
	}


	//draw the player
	player.draw(player.x, player.y);

	//draw all the bullets
	for (i = 0; i < MAX_BULLETS; i++)
	{
		if (bullet[i].active)
		{
				bullet[i].draw(bullet[i].x, bullet[i].y);
		}
	}

	//draw all the invaders
	for (i = 0;i < 10; i++)	
	{
		if (invader[i].alive == true)	invader[i].draw(invader[i].x, invader[i].y);
	}

	//write some variable to screen

	textprintf(buffer,font,5,240,makecol16(255,255,255),"Credits %d",player.score);

	//draw the explosions
	for (i=0;i<30;i++)
	{
		if (explosion[i].active)	explosion[i].draw();
	}

	//draw the power bar
	rectfill(buffer, scrx-30, scry- 30, scrx - 20, (scry - 30) - player.energy*10, makecol(255, 200, 30));
	
	//draw the number of lives
	masked_blit(bmp_little_ship, buffer, 0, 0, 5, 200, bmp_little_ship->w, bmp_little_ship->h);
	textprintf(buffer,font,18 + bmp_little_ship->w/2, 200 + bmp_little_ship->h/2,makecol16(255,255,255),"X %d",player.lives);
	
	//write the level number
	textprintf(buffer,font,5,280,makecol16(255,255,255),"level %d",level);

	//draw the weapons pwr
	textprintf(buffer,font,18, 230,makecol16(255,255,255),"gun pwr %d",player.gun_power);

	//draw all the power ups the layer has
	if (player.rapid)	blit(bmp_powerup[RAPID], buffer, 0, 0, 5, 400, bmp_powerup[RAPID]->w, bmp_powerup[RAPID]->h);
	if (player.pwr_agility)	blit(bmp_powerup[AGILITY], buffer, 0, 0, 5, 440, bmp_powerup[AGILITY]->w, bmp_powerup[AGILITY]->h);
	
	//print some test variables
	textprintf(buffer,font,5, 400,makecol16(255,255,255),"num p bullets %d",num_player_bullets);
	textprintf(buffer,font,5, 420,makecol16(255,255,255),"num i bullets %d",num_invader_bullets);

	//print some player test variables
	textprintf(buffer,font,5, 440,makecol16(255,255,255),"player x %d",player.x);
	if (num_player_bullets > 0) {
		textprintf(buffer,font,5, 460,makecol16(255,255,255),"test b %d x %d",testbullet, bullet[testbullet].x);
	}
	else textprintf(buffer,font,5, 460,makecol16(255,255,255),"no p b");

	textprintf(buffer,font,5, 480,makecol16(255,255,255),"b 0 type %d",bullet[0].type);


	return;
}


/*********************************************************************************************
				get bullet number : gets the lowest number of the free bullet
*********************************************************************************************/
int get_bulletnum()
{
	for (int i = 0;i< MAX_BULLETS;i++)
	{
		if (bullet[i].active == false) return i;
	}
	exit(-1);
}


/*********************************************************************************************
				get bullet number : gets the lowest number of the free bullet
*********************************************************************************************/
int get_powerup_num()
{
	for (int i = 0;i< 10;i++)
	{
		if (powerup[i].active == false) return i;
	}
	exit(-1);
}


/*********************************************************************************************
				get star number : gets the lowest number of the free star
*********************************************************************************************/
int get_star_num()
{
	for (int i = 0;i< MAX_STARS;i++)
	{
		if (star[i].active == false) return i;
	}
	exit(-1);
}


/*********************************************************************************************
				get star explosion : gets the lowest number of the free explosion
*********************************************************************************************/
int get_explosion_num()
{
	for (int i = 0;i< 30;i++)
	{
		if (explosion[i].active == false) return i;
	}
	exit(-1);
}


/*********************************************************************************************
							check_bullets : cleans up unused bullets
*********************************************************************************************/
void check_bullets()
{
	for (int i=0; i < MAX_BULLETS; i++)
	{
		//check the players bullets
		if (bullet[i].active && (bullet[i].y > scry || bullet[i].y < 0))	bullet[i].reset();
		
	}
	return;
}

/*********************************************************************************************
									move invaders 
*********************************************************************************************/
void move_invaders(int &dir)
{
	int i = 0;
	int FirstInvader = 0;
	int LastInvader = MAX_INVADERS;

	// finds the array number of the lowest invader alive
	while(invader[FirstInvader].alive == false) FirstInvader++;

	// finds the array number of the highest invader alive
	while(invader[LastInvader].alive == false) LastInvader--;
		
	//if its at the far right change dir and move them down
	if (dir == RIGHT && invader[RightMostInvader].x > scrx - 10) 
	{
		dir = LEFT;
		for (i = 0; i < MAX_INVADERS; i++) 
		{
			invader[i].y += 30;
			invader[i].bounding_box.move(0,30);
		}

	}

	//if its at the far left change dir and move them down
	if (dir == LEFT && invader[LeftMostInvader].x < 10) 
	{
		dir = RIGHT;
		for (i = 0; i < MAX_INVADERS; i++) 
		{
			invader[i].y += 30;
			invader[i].bounding_box.move(0, 30);
		}
	}

	//if direction is right move invaders 1 unit right
	if (dir == RIGHT)
	{
		for (i = FirstInvader;i <= LastInvader;i++)
		{
			if (invader[i].alive == true)	
			{
				invader[i].x ++;
				invader[i].bounding_box.move(1, 0);
			}
		}
	}

	//if direction is left move invaders 1 unit left
	if (dir == LEFT)
	{
		for (i = FirstInvader;i <= LastInvader;i++)
		{
			if (invader[i].alive == true)
			{
				invader[i].x --;
				invader[i].bounding_box.move(-1, 0);
			}
		}
	}

	return;
}


/*********************************************************************************************
			find right most invader : finds the number of the furthest right invader
*********************************************************************************************/
int Get_Right_Invader()
{	
	int i = 0;
	int RightInvader;
	int RightInvaderX;

	// finds the array number of the lowest invader alive
	while(invader[i].alive == false) i++;

	RightInvaderX = invader[i].x;
	RightInvader = i;
	for (i = RightInvader; i < MAX_INVADERS; i++)
	{
		if (invader[i].alive == true)
		{
			if (invader[i].x > RightInvaderX)
			{
				RightInvaderX = invader[i].x;
				RightInvader = i;
			}
		}
	}
return RightInvader;
}


/*********************************************************************************************
			find left most invader : finds the number of the furthest left invader
*********************************************************************************************/
int Get_Left_Invader()
{
	int i = 0;
	int LeftInvader;
	int LeftInvaderX;

	// finds the array number of the lowest invader alive
	while(invader[i].alive == false) i++;

	LeftInvaderX = invader[i].x;
	LeftInvader = i;
	for (i = LeftInvader; i < MAX_INVADERS; i++)
	{
		if (invader[i].alive == true)
		{
			if (invader[i].x < LeftInvaderX)
			{
				LeftInvaderX = invader[i].x;
				LeftInvader = i;
			}
		}
	}
return LeftInvader;
}


/*********************************************************************************************
									load_Graphics
*********************************************************************************************/
void load_graphics()
{
	bmp_player_ship	   = load_bmp("SHIP.bmp", 0);
	bmp_bullet		   = load_bmp("PlayerBullet.bmp", 0);
	bmp_invader		   = load_bmp("INVADERS.bmp", 0);
	bmp_invader_bullet = load_bmp("INVADERBULLET.bmp", 0);
	bmp_little_ship    = load_bmp("LITTLESHIP.bmp", 0);

	//load all the explosion graphics
	bmp_powerup[0] = load_bmp("PWRRAPID.bmp", 0);	//rapid fire
	bmp_powerup[1] = load_bmp("PWR1UP.bmp", 0);		//extra life
	bmp_powerup[2] = load_bmp("PWRLIFE.bmp", 0);	//extra energy
	bmp_powerup[3] = load_bmp("PWRAGILITY.bmp", 0);	//extra agility
	bmp_powerup[4] = load_bmp("PWRDOUBLE.bmp", 0);	//double shot
	bmp_powerup[5] = load_bmp("PWRSPREAD.bmp", 0);	//spread gun
	bmp_powerup[6] = load_bmp("PWRUP.bmp", 0);		//more powerful gun
	bmp_powerup[7] = load_bmp("PWRSHRINK.bmp", 0);	//ship shrink


	//load all the explosion graphics
	bmp_explosion[0] = load_bmp("EXPLOSION1.bmp", 0);
	bmp_explosion[1] = load_bmp("EXPLOSION2.bmp", 0);
	bmp_explosion[2] = load_bmp("EXPLOSION3.bmp", 0);
	bmp_explosion[3] = load_bmp("EXPLOSION4.bmp", 0);
	bmp_explosion[4] = load_bmp("EXPLOSION5.bmp", 0);

	//load the music and sound fx
	wav_explosion = load_sample("EXPLOSION.wav");
	wav_shoot	  = load_sample("shoot.wav");
	//wav_music	  = load_sample("music.wav");

	return;
}


/*********************************************************************************************
									initialize
*********************************************************************************************/
void initialize()
{
	//set up allegro
	allegro_init();
	install_keyboard();
	text_mode(-1); 

	set_color_depth(16);
	set_gfx_mode(GFX_AUTODETECT, scrx, scry, 0, 0);
	buffer = create_bitmap(SCREEN_W, SCREEN_H);

	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, 0);

	load_graphics();

	//randomize the timer for random numbers
	srand ((unsigned)time (NULL));

	return;
}


/*********************************************************************************************
									player shoot
*********************************************************************************************/
void player_shoot()
{
	int free_bullet = get_bulletnum();

	bullet[free_bullet].x = player.x;
	bullet[free_bullet].y = player.y - 55;
	bullet[free_bullet].active = true;
	bullet[free_bullet].direction = UP;
	bullet[free_bullet].type = PLAYER;
	bullet[free_bullet].bounding_box.set(bullet[free_bullet].y - 5,bullet[free_bullet].y + 5,bullet[free_bullet].x-3,bullet[free_bullet].x+3);

	num_player_bullets++;
	
	return;
}


/*********************************************************************************************
									invader shoot
*********************************************************************************************/
void invader_shoot()
{
	int shooting_invader;
	int free_bullet = get_bulletnum();

	shooting_invader = rand()%10;
	while (invader[shooting_invader].alive == false)	shooting_invader = rand()%10;

	bullet[free_bullet].x = invader[shooting_invader].x;
	bullet[free_bullet].y = invader[shooting_invader].y + 5;
	bullet[free_bullet].active = true;
	bullet[free_bullet].direction = DOWN;
	bullet[free_bullet].type = INVADER;
	bullet[free_bullet].bounding_box.set(bullet[free_bullet].y - 4,bullet[free_bullet].y + 4,bullet[free_bullet].x - 4,bullet[free_bullet].x + 4);

	num_invader_bullets++;

	return;
}


/*********************************************************************************************
										main menu
*********************************************************************************************/
int main_menu()
{
	int selection = 1;
	int Y=203;
	bool selecting = true;

	while(selecting)
	{
		clear(buffer);
		textout(buffer, font, "NEW GAME", 200, 200, makecol16(255,255,255));
		textout(buffer, font, "HIGH SCORES", 200, 220, makecol16(255,255,255));
		textout(buffer, font, "QUIT", 200, 240, makecol16(255,255,255));
		circlefill(buffer, 190, Y, 5, makecol16(0,255,0));

		vsync();
		blit(buffer, screen, 0, 0, 0, 0,SCREEN_W, SCREEN_H);

		player.lives = 2;

		if (key[KEY_DOWN] && selection !=3)	
		{
			selection++;
			Y += 20;
		}
		if (key[KEY_UP] && selection !=1) 
		{
			selection--;
			Y -=20;
		}
		if (key[KEY_ENTER]) selecting = false;
		for (int i = 0; i < 5000000; i++);

	}
	return selection;
}


/*********************************************************************************************
									  high scores
*********************************************************************************************/
void high_scores()
{
	return;
}


/*********************************************************************************************
									  initialize level
*********************************************************************************************/
void initialize_level(int level)
{
	int i;


	player.reset();		//initialize some player variables

	for (i=0; i<10; i++)	powerup[i].reset();	//reset all the powerups

	for (i = 0; i<MAX_BULLETS;i++)	bullet[i].reset(); //reset all the bullets

	for (i = 0; i<30;i++)	explosion[i].reset();	//reset all the explosions

	num_invaders = 10;	//reset the number of invaders
	num_player_bullets = 0;
	num_invader_bullets = 0;

	//initialize some invader attribs
	for (i=0;i<MAX_INVADERS;i++)
	{
		if (i<10) 
		{
			invader[i].alive = true;
			invader[i].y = 50;
			invader[i].x = i*30 + 10;
			invader[i].energy = level;
			invader[i].bounding_box.set(invader[i].y - 13,invader[i].y + 13, invader[i].x - 13, invader[i].x + 13);
		}
		else invader[i].alive = false;
	}

	RightMostInvader = Get_Right_Invader();
	LeftMostInvader = Get_Left_Invader();



	//start screen
	clear(screen);
	textprintf(screen,font,scrx/2,300,makecol16(255,255,255),"level %d",level);
	textout(screen, font, "press enter to start", scrx/2, 330, makecol16(255,255,255));
	while(!key[KEY_ENTER]);

	clear(screen);
	return;
}


/*********************************************************************************************
									  fill screen with stars
*********************************************************************************************/
void fill_screen_with_stars()
{
	for (int i=0;i<180;i++)
	{
		star[i].create2();
	}
	return;
}


/*********************************************************************************************
									  collision detection
*********************************************************************************************/
void collision_detection()
{
	int i;
	int k;
	int explosionnum = 0;
	int powerupnum = 0;

	for (i=0; i < MAX_BULLETS; i++)
	{
		//invader bullet to player collisions
		if (bullet[i].type == INVADER && bullet[i].active)
		{
			if (BBCD(bullet[i].bounding_box, player.bounding_box))	
			{
				bullet[i].reset();
				explosionnum = get_explosion_num();
				explosion[explosionnum].active = true;
				explosion[explosionnum].frame_num = 0;
				explosion[explosionnum].x = bullet[i].x;
				explosion[explosionnum].y = bullet[i].y + 40;
				play_sample (wav_explosion, 255, 128, 1000, 0);
				if (player.energy > 0)	player.energy--;
			}
		}

		//**************************************************************************************
		//player bullet to invader collisions
		if (bullet[i].type == PLAYER && bullet[i].active)
		{
			for (k=0; k < MAX_INVADERS; k++)
			{
				if (invader[k].alive && BBCD(bullet[i].bounding_box, invader[k].bounding_box))
				{
					//destroy the bullet
					bullet[i].reset();

					//reduce the energy of the invader and see if it is killed
					invader[k].energy -= player.gun_power;
					if (invader[k].energy <= 0) 
					{
						num_invaders--;
						invader[k].alive = false;
						player.score += 5;			
					
						//determine if there will be a power up and of what type
						if (rand()%3 == 0)
						{
							powerupnum = get_powerup_num();
							powerup[powerupnum].type = rand()%8;
							powerup[powerupnum].active = true;
							powerup[powerupnum].x = invader[k].x;
							powerup[powerupnum].y = invader[k].y + 10;
							powerup[powerupnum].bounding_box.set(powerup[powerupnum].y - 15,powerup[powerupnum].y + 15,powerup[powerupnum].x - 15,powerup[powerupnum].x + 15);
						}
					}

					//find an unused explosion and create an explosion
					explosionnum = get_explosion_num();
					explosion[explosionnum].active = true;
					explosion[explosionnum].frame_num = 0;
					explosion[explosionnum].x = bullet[i].x;
					explosion[explosionnum].y = bullet[i].y + 5;
					play_sample (wav_explosion, 255, 128, 1000, 0);
					
				}
			}
		}
	}


	//**************************************************************************************
	//powerup to player collision detection
	for (i = 0; i<10; i++)
	{
		if (powerup[i].active && BBCD(powerup[i].bounding_box, player.bounding_box))
		{
			powerup[i].active = false;
			if (powerup[i].type == RAPID)
			{
				player.rapid_time_left = 1000;
				player.rapid = true;
			}
			if (powerup[i].type == EXTRAGUY)	player.lives++;
			if (powerup[i].type == ENERGY)		player.energy+=2;
			if (powerup[i].type == AGILITY)	
			{
				player.agility = 7;
				player.pwr_agility = true;
			}
			if (powerup[i].type == PWRUP)		player.gun_power++;
		}
	}

	return;
}


//******************************************************************************************
//									move graphcis
//******************************************************************************************
void move_graphics()
{
	int i;

	//move player
	player.move(player.x,player.y);

	//move Bullets
	for (i =0; i < MAX_BULLETS; i++)
	{
		if (bullet[i].active)
		{
			bullet[i].bounding_box.move(0, bullet[i].direction*5);
			bullet[i].move(bullet[i].y, bullet[i].direction);
			bullet[i].x = bullet[i].bounding_box.left + 3;
		}
	}

	//first check to see if the right and left invaders are still alive if not renew them
	if (invader[RightMostInvader].alive == false) RightMostInvader = Get_Right_Invader();
	if (invader[LeftMostInvader].alive == false)  LeftMostInvader = Get_Left_Invader();
		
	//next move the invaders
	move_invaders(invaderDirection);

	//move the stars
	for (i = 0; i < MAX_STARS; i++)
	{
		if (star[i].active == true)		star[i].move();
	}

	//move the powerups
	for (i = 0; i < 10; i++)
	{
		if (powerup[i].active == true)		powerup[i].move();
	}

	//check the powerups
	for (i = 0; i<10; i++)	powerup[i].check();

	return;
}
//******************************************************************************************
//									SHUTDOWN
//******************************************************************************************


void shut_down(void)
{
	int i;

	//destroy all of the bitmaps
	destroy_bitmap(buffer);
	destroy_bitmap(bmp_player_ship);
	destroy_bitmap(bmp_bullet);
	destroy_bitmap(bmp_invader);
	destroy_bitmap(bmp_invader_bullet);
	destroy_bitmap(bmp_little_ship);
	for (i=0; i<4; i++)	destroy_bitmap(bmp_powerup[i]);
	for (i=0; i<4; i++) destroy_bitmap(bmp_explosion[i]);

	//destroy the sound samples
	destroy_sample(wav_shoot);
	destroy_sample(wav_explosion);
	//destroy_sample(wav_music);

	//exit allegro
	allegro_exit();

	return;
}

/*********************************************************************************************
									  game loop
*********************************************************************************************/
void game_loop()
{
	//initialize game loop variables
	int time_until_next_shot = 0;
	int time_until_next_invader_shot = 0;
	int i;		

	invaderDirection = RIGHT;

	initialize_level(level);

	RightMostInvader = Get_Right_Invader();
	LeftMostInvader = Get_Left_Invader();
	invader_shoot_speed = 30;

	player.rapid_time_left = 0;

	fill_screen_with_stars();
	player.score = 0;
	//play_sample (wav_music, 255, 128, 1000,1);
	player.lives = 100;

	while (player.lives > 0)
	{
		clear(buffer);
		update_screen();

		//add stars
		star[get_star_num()].create();

		check_bullets();	//delete unused bullets

		//keyboard_input();
		if (key[KEY_ESC]) player.lives = 0;

		//if space is pressed create new player bullet
		if (time_until_next_shot == 0)
		{
			if (key[KEY_SPACE])
			{
				player_shoot();
				if (player.rapid_time_left > 0) time_until_next_shot = 10;
				if (player.rapid_time_left <= 0) 
				{
					time_until_next_shot = 20;
					player.rapid = false;
				}
				play_sample (wav_shoot, 255, 128, 1000, 0);
			}
		}

		//do the shooting for the invaders
		if (time_until_next_invader_shot == 0 )
		{
			invader_shoot();
			time_until_next_invader_shot = invader_shoot_speed;
		}

		move_graphics();

		collision_detection();	//handles all the collision detection

		//delete unused stars
		for (i=0;i<MAX_STARS;i++)	star[i].check();

		//delete unused explosions
		for (i=0;i<30;i++)	explosion[i].check();

		//delete unused powerups
		for (i=0;i<30;i++)	powerup[i].check();
	
		//draw the buffer to the screen
		vsync();
		blit(buffer, screen, 0, 0, 0, 0,SCREEN_W, SCREEN_H);
		
		//decrease counter variables
		if (time_until_next_shot > 0)	time_until_next_shot--;
		if (time_until_next_invader_shot > 0) time_until_next_invader_shot--;
		if (player.rapid_time_left > 0)		player.rapid_time_left--;

		//determin if the player has been killed
		if (player.energy == 0)
		{
			player.lives--;
			player.energy = 2;
			if (player.lives > 0)  initialize_level(level);
			invaderDirection = RIGHT;
		}

		//determine if the player has won the level
		if (num_invaders == 0)
		{
			level++;
			invaderDirection = RIGHT;
			if (invader_shoot_speed > 5)	invader_shoot_speed -=5;
			initialize_level(level);
		}

	}
	return;
}


/*********************************************************************************************
										main
*********************************************************************************************/
int main()
{
	int selection = 0;
	initialize();
	
	selection = main_menu();
	while (selection == 1 || selection == 2)
	{
		if (selection == 2)	high_scores();
		else game_loop();
		selection = main_menu();
	}

	shut_down();
	return 0;
}

END_OF_MAIN();